/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987-1990 Texas Instruments Incorporated.              */
/*  All rights reserved.                                                 */
/*                                                                       */

/*------------------------------------------------------------------------------

TBServer
------------------------------------------------------------------------------*/
 
#include "Types.r"
#include "SysTypes.r"
include "traps";

/* These define's are used in the MENU resources to disable specific
   menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b00001
#define MenuItem2	0b00010
#define MenuItem3	0b00100
#define MenuItem4	0b01000
#define MenuItem5	0b10000


/* sbw 12/11/89 removed size resource type definition, use mpw 3.0's instead */

resource 'SIZE' (-1) {
		dontSaveScreen, 				/* Save screen			*/
		acceptSuspendResumeEvents,		/* suspend-resume		*/
		enableOptionSwitch,				/* Options switch		*/
		canBackground,					/* accept Juggler background	*/
		multiFinderAware,				/* Juggler aware		*/
		backgroundAndForeground,		
		dontGetFrontClicks,				/* ignore user 'bring to front' clicks */
		ignoreChildDiedEvents,			/* used by debuggers	*/
		not32BitCompatible,				/* maybe in 7.0			 */
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		500000,							/* size 				*/
		500000							/* min size      		*/
};


/* ab 11/8/88.  */
type 'TIMX' as 'STR ';

resource 'TIMX' (0) {
	"microExplorer Toolbox Server"
};


data 'ICN#' (128) { /* TI Bug ICON....Keith 1/27/88 */         /* ab 11/28/88 */
	$"0000 0000 007F 0000 007F 0000 007F 0000" 
	$"007F 0000 007F 0000 007F 0C00 007F 1E00" 
	$"007F CCF0 007F C1F8 007F DDF8 007F DDF8" 
	$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE" 
	$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE" 
	$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0" 
	$"0003 FF80 0001 FF00 0001 FE00 0000 FE00" 
	$"0000 7E00 0000 3F00 0000 0F00 0000 0000" 
	$"00FF 8000 00FF 8000 00FF 8000 00FF 8000" 
	$"00FF 8000 00FF 8C00 00FF 9E00 00FF FFF0" 
	$"00FF EFF8 00FF FFFC 00FF FFFC 00FF FFFC" 
	$"FFFF FFFC FFFE 1CFC FFFF FFFE 7FFF FFFF" 
	$"3FFF FFFF 1FFF FFFF 0FFF BFFF 07FF BFFF" 
	$"07FF FFFF 03E7 8FFE 01C7 83FC 0007 FFF0" 
	$"0007 FFC0 0003 FF80 0003 FF00 0001 FF00" 
	$"0000 FF00 0000 7F80 0000 3F80 0000 0F00" 
};

resource 'BNDL' (128) {				/* ab 11/8/88.  */
	'TIMX',
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};


resource 'FREF' (128) {
	'APPL',
	0,
	""
};
 
data 'ALRT' (260) {
	$"0054 005E 013A 0230 0104 CCCC"                  /* .T.^.:.0.. */
};

data 'DITL' (260) {
	$"0002 0000 0000 00B7 000B 00CB 0047 0402"        /* ...........G.. */
	$"4F4B 0000 0000 0007 005A 0058 01AB 0804"        /* OK.......Z.X... */
	$"5E30 5E31 0000 0000 005E 005C 00B6 01AC"        /* ^0^1.....^.\.. */
	$"0804 5E32 5E33"                                 /* ..^2^3 */
};

data 'NAME' (0, "Application-name") {
	$"1354 423A 3A72 7063 2D61 7070 6C69 6361"        /* .TB::rpc-applica */
	$"7469 6F6E"                                      /* tion */
};

data 'DLOG' (128, "About Hooks") {
	$"0072 0102 014E 0244 0001 0100 0000 0000"            /* .r...N.D........ */
	$"0000 0080 00"                                       /* .... */
};

data 'DITL' (128) {
	$"0003 0000 0000 00C1 00C7 00D9 011F 0408"            /* .............. */
	$"436F 6E74 696E 7565 0000 0000 0022 0002"            /* Continue.....".. */
	$"0059 0118 8871 2020 2054 6869 7320 6578"            /* .Y..q   This ex */
	$"616D 706C 6520 6465 6D6F 6E73 7472 6174"            /* ample demonstrat */
	$"6573 2074 6865 2075 7365 206F 660D 2020"            /* es the use of   */
	$"2074 6865 2074 6872 6565 2054 4253 6572"            /*  the three TBSer */
	$"7665 7220 686F 6F6B 7320 746F 2069 6D70"            /* ver hooks to imp */
	$"6C65 6D65 6E74 0D20 2020 6120 7369 6D70"            /* lement   a simp */
	$"6C65 204D 6163 2D73 6964 6520 5250 4320"            /* le Mac-side RPC  */
	$"7365 7276 6572 3A13 0000 0000 0065 0015"            /* server:......e.. */
	$"00B6 0118 886F 2020 2041 7070 6C69 6361"            /* ...o   Applica */
	$"7469 6F6E 5F49 6E69 745F 486F 6F6B 0D20"            /* tion_Init_Hook  */
	$"2020 4170 706C 6963 6174 696F 6E5F 5275"            /*   Application_Ru */
	$"6E5F 486F 6F6B 0D20 2020 4170 706C 6963"            /* n_Hook   Applic */
	$"6174 696F 6E5F 436C 6561 6E75 705F 486F"            /* ation_Cleanup_Ho */
	$"6F6B 0D0D 5365 6520 486F 6F6B 732E 4320"            /* okSee Hooks.C  */
	$"666F 7220 6D6F 7265 2069 6E66 6F72 6D61"            /* for more informa */
	$"7469 6F6E 2E6F 0000 0000 0002 000E 0019"            /* tion.o.......... */
	$"010A 8821 2020 2020 2020 5449 204D 6963"            /* ..!      TI Mic */
	$"726F 4578 706C 6F72 6572 2052 5043 2053"            /* roExplorer RPC S */
	$"6572 7665 7265"                                     /* ervere */
};

resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About Hooks",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	allEnabled,
	enabled, "File",
	{
		"Quit",
			noicon, noKey, nomark, plain
	}
};

resource 'MENU' (130, "Verbose", preload) {
	130, textMenuProc,
	allEnabled,
	enabled, "Verbose",
	{
		"ON",
			noicon, noKey, nomark, plain;
		"OFF",
			noicon, noKey, nomark, plain
	}
};


/* Lisp checks this resource to determine the type of tbserver.  If your tbserver *
 * is version 6.xx.xx or 7.xx.xx use id = 2, otherwise use id = 0.                */

data 'evts' (2, "Async events") {
	$"FF"                                             /* . */
};
